//this file is part of eMule
//Copyright (C)2002-2006 Merkur ( strEmail.Format("%s@%s", "devteam", "emule-project.net") / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//>>> shadow2004::Updates-Prefspage
#include "stdafx.h"
#include "emule.h"
#include "EMF/PPGs/PPgUpdates.h"
#include "OtherFunctions.h"
#include "emuledlg.h"
//>>> shadow2004::IP2Country [EastShare]
#include "Preferences.h"
#include "EMF/IP2Country/IP2Country.h" 
//<<< shadow2004::IP2Country [EastShare]
#include "MenuCmds.h" //>>> WiZaRd:EMF Link
#include "EMF/ModIcon/ModIconMapping.h"	//>>> shadow2004::ModIconDLL Update
#include "IPfilter.h"		//shadow2004::IPFilter-Update [Morph]
#include "EMF/ModName/Modname.h"	//shadow2004::ed2k updates
#include "partfile.h"			//shadow2004::ed2k updates
#include "CustomAutoComplete.h"		//>>> shadow2004::IPFilter-Autocomplete

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define	IPFILTERUPDATEURL_STRINGS_EMF	_T("EMF_IPFilterUpdateURLs.dat")	//>>> shadow2004::IPFilter-Autocomplete

IMPLEMENT_DYNAMIC(CPPgUpdates, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPgUpdates, CPropertyPage)
//>>> shadow2004::IP2Country [EastShare]
	ON_BN_CLICKED(IDC_UPDATES_I2CSTARTUP, OnSettingsChange)
	ON_EN_CHANGE(IDC_UPDATES_URLFORI2C, OnSettingsChange)
	ON_EN_CHANGE(IDC_UPDATES_URLFORI2CVERFILE, OnSettingsChange)
	ON_BN_CLICKED(IDC_UPDATES_I2CUPDATE, OnBnClickedI2CUpdate)
	ON_BN_CLICKED(IDC_UPDATES_I2CRESET, OnBnClickedResetI2CURL)
//<<< shadow2004::IP2Country [EastShare]
//>>> shadow2004::ModIconDLL Update
	ON_BN_CLICKED(IDC_UPDATES_MIMSTARTUP, OnSettingsChange)
	ON_EN_CHANGE(IDC_UPDATES_URLFORMIM, OnSettingsChange)
	ON_BN_CLICKED(IDC_UPDATES_MIMUPDATE, OnBnClickedMIMUpdate)
	ON_BN_CLICKED(IDC_UPDATES_MIMRESET, OnBnClickedResetMIMURL)
//<<< shadow2004::ModIconDLL Update

//>>> shadow2004::IPFilter-Update [Morph]
	ON_BN_CLICKED(IDC_IPFILTER_IPFSTARTUP,OnSettingsChange)
	ON_EN_CHANGE(IDC_IPFILTER_URLFORIPF, OnSettingsChange)
	ON_BN_CLICKED(IDC_IPFILTER_IPFRESET, OnResetIPFilterURL)
	ON_BN_CLICKED(IDC_IPFILTER_IPFUPDATE, OnLoadIPFilter)
//<<< shadow2004::IPFilter-Update [Morph]
//>>> shadow2004::IPFilter-Autocomplete
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_IPFILTER_LIST,OnListClicked)
//<<< shadow2004::IPFilter-Autocomplete
//>>> shadow2004::ed2k updates
	ON_BN_CLICKED(IDC_IPFILTER_AUTODL, OnSettingsChange)	
	ON_BN_CLICKED(IDC_IPFILTER_ED2KPRIO, OnSettingsChange)
	ON_BN_CLICKED(IDC_IPFILTER_ED2KVLOW, OnSettingsChange)
	ON_BN_CLICKED(IDC_IPFILTER_ED2KLOW, OnSettingsChange)
	ON_BN_CLICKED(IDC_IPFILTER_ED2KNORM, OnSettingsChange)
	ON_BN_CLICKED(IDC_IPFILTER_ED2KHIGH, OnSettingsChange)
	ON_BN_CLICKED(IDC_IPFILTER_ED2KREL, OnSettingsChange)
	ON_BN_CLICKED(IDC_IPFILTER_ED2KAUTO, OnSettingsChange)
//<<< shadow2004::ed2k updates

END_MESSAGE_MAP()

CPPgUpdates::CPPgUpdates()
	: CPropertyPage(CPPgUpdates::IDD)
{
	m_pemfIPFilterURL = NULL;	//>>> shadow2004::IPFilter-Autocomplete
}

CPPgUpdates::~CPPgUpdates()
{
}

void CPPgUpdates::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
}

BOOL CPPgUpdates::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	InitWindowStyles(this);

	LoadSettings();
	Localize();

//>>> shadow2004::IPFilter-Autocomplete
	if (thePrefs.GetUseAutocompletion())
	{
		if (!m_pemfIPFilterURL)
		{
			m_pemfIPFilterURL = new CCustomAutoComplete();
			m_pemfIPFilterURL->AddRef();
			if (m_pemfIPFilterURL->Bind(::GetDlgItem(m_hWnd, IDC_IPFILTER_URLFORIPF), ACO_UPDOWNKEYDROPSLIST | ACO_AUTOSUGGEST | ACO_FILTERPREFIXES ))
				m_pemfIPFilterURL->LoadList(thePrefs.GetMuleDirectory(EMULE_CONFIGDIR) + IPFILTERUPDATEURL_STRINGS_EMF);
		}
		//SetDlgItemText(IDC_IPFILTER_URLFORIPF,m_pemfIPFilterURL->GetItem(0));
		if (theApp.m_fontSymbol.m_hObject)
		{
			GetDlgItem(IDC_IPFILTER_LIST)->SetFont(&theApp.m_fontSymbol);
			GetDlgItem(IDC_IPFILTER_LIST)->SetWindowText(_T("6")); // show a down-arrow
		}
	}
	else
		GetDlgItem(IDC_IPFILTER_LIST)->ShowWindow(SW_HIDE);
//<<< shadow2004::IPFilter-Autocomplete

	OnSettingsChange(); //enable/disable ipfilter prio controls

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CPPgUpdates::LoadSettings(void)
{
	if(m_hWnd)
	{
		CString strBuffer;
//>>> shadow2004::IP2Country [EastShare]
		CheckDlgButton(IDC_UPDATES_I2CSTARTUP, thePrefs.IsAutoUpdateIP2CountryEnabled());
		GetDlgItem(IDC_UPDATES_URLFORI2C)->SetWindowText(thePrefs.GetIP2CountryUpdateURL());
		GetDlgItem(IDC_UPDATES_URLFORI2CVERFILE)->SetWindowText(thePrefs.GetIP2CountryUpdateVerURL());
		strBuffer.Format(_T("v%u"), thePrefs.GetIP2CountryVersion());
		GetDlgItem(IDC_UPDATES_I2CVERSION)->SetWindowText(strBuffer);
//<<< shadow2004::IP2Country [EastShare]
//>>> shadow2004::ModIconDLL Update
		CheckDlgButton(IDC_UPDATES_MIMSTARTUP, thePrefs.IsAutoUpdateModIconDllEnabled());
		GetDlgItem(IDC_UPDATES_URLFORMIM)->SetWindowText(thePrefs.GetModIconDllUpdateURL());
		GetDlgItem(IDC_UPDATES_MIMVERSION)->SetWindowText(theApp.theModIconMap->GetVersionString());
//<<< shadow2004::ModIconDLL Update

//>>> shadow2004::IPFilter-Update [Morph]
		GetDlgItem(IDC_IPFILTER_URLFORIPF)->SetWindowText(thePrefs.GetUpdateURLIPFilter());
		CheckDlgButton(IDC_IPFILTER_IPFSTARTUP,	thePrefs.IsAutoUpdateIPFilterEnabled());
		strBuffer.Format(L"v%u", thePrefs.GetIPfilterVersion());
		if(thePrefs.GetDLingIpFilterVersion())
			strBuffer.AppendFormat(L" - %s v%u", GetResString(IDS_CD_CDOWN), thePrefs.GetDLingIpFilterVersion());
		GetDlgItem(IDC_IPFILTER_IPFVERSION)->SetWindowText(strBuffer);
//<<< shadow2004::IPFilter-Update [Morph]
//>>> shadow2004::ed2k updates
		CheckDlgButton(IDC_IPFILTER_AUTODL,	thePrefs.GetAutoResumePausedIPFilter());
		CheckDlgButton(IDC_IPFILTER_ED2KPRIO, thePrefs.GetIPFilterUploadPrioManuell());
		int button;
		switch(thePrefs.GetIPFilterUploadPrio())
		{
			case PR_VERYLOW:
				button = 0;
				break;
			case PR_LOW:
				button = 1;
				break;
			case PR_NORMAL:
				button = 2;
				break;
			case PR_HIGH:
				button = 3;
				break;
			case PR_VERYHIGH:
				button = 4;
				break;
			default:
				ASSERT(0);  //should not happen... flow over!
			case PR_AUTO:
				button = 5;
				break;
		}
		CheckRadioButton(IDC_IPFILTER_ED2KVLOW, IDC_IPFILTER_ED2KAUTO, IDC_IPFILTER_ED2KVLOW + button);
//<<< shadow2004::ed2k updates
	}
}

BOOL CPPgUpdates::OnApply()
{
	CString buffer;

//>>> shadow2004::IP2Country [EastShare]
	thePrefs.SetAutoUpdateIP2Country(IsDlgButtonChecked(IDC_UPDATES_I2CSTARTUP)!=0);
	GetDlgItem(IDC_UPDATES_URLFORI2C)->GetWindowText(thePrefs.m_strIP2CountryUpdateURL);
	GetDlgItem(IDC_UPDATES_URLFORI2CVERFILE)->GetWindowText(thePrefs.m_strIP2CountryUpdateVerURL);
//<<< shadow2004::IP2Country [EastShare]
//>>> shadow2004::ModIconDLL Update
	thePrefs.SetAutoUpdateModIconDll(IsDlgButtonChecked(IDC_UPDATES_MIMSTARTUP)!=0);
	GetDlgItem(IDC_UPDATES_URLFORMIM)->GetWindowText(thePrefs.m_strModIconDllUpdateURL);
//>>> shadow2004::ModIconDLL Update

//>>> shadow2004::IPFilter-Update [Morph]
	thePrefs.SetAutoUpdateIPFilter(IsDlgButtonChecked(IDC_IPFILTER_IPFSTARTUP)!=0);
	GetDlgItem(IDC_IPFILTER_URLFORIPF)->GetWindowText(thePrefs.strUpdateURLIPFilter);
//<<< shadow2004::IPFilter-Update [Morph]
//>>> shadow2004::ed2k updates
	thePrefs.SetAutoResumePausedIPFilter(IsDlgButtonChecked(IDC_IPFILTER_AUTODL)!= 0);
	thePrefs.SetIPFilterUploadPrioManuell(IsDlgButtonChecked(IDC_IPFILTER_ED2KPRIO) != 0);
	switch(GetCheckedRadioButton(IDC_IPFILTER_ED2KVLOW, IDC_IPFILTER_ED2KAUTO))
	{
		case IDC_IPFILTER_ED2KVLOW:
			thePrefs.SetIPFilterULPrio(PR_VERYLOW);
			break;

		case IDC_IPFILTER_ED2KLOW:
			thePrefs.SetIPFilterULPrio(PR_LOW);
			break;

		case IDC_IPFILTER_ED2KNORM:
            thePrefs.SetIPFilterULPrio(PR_NORMAL);
			break;

		case IDC_IPFILTER_ED2KHIGH:
            thePrefs.SetIPFilterULPrio(PR_HIGH);
			break;

		case IDC_IPFILTER_ED2KREL:
			thePrefs.SetIPFilterULPrio(PR_VERYHIGH);
			break;

		default:
			ASSERT(0); //should not happen... flow over!
		case IDC_IPFILTER_ED2KAUTO:
			thePrefs.SetIPFilterULPrio(PR_AUTO);
			break;
	}
//<<< shadow2004::ed2k updates
	SetModified(FALSE);
	
	LoadSettings();
	return CPropertyPage::OnApply();
}

void CPPgUpdates::Localize(void)
{
	if(m_hWnd)
	{
		SetWindowText(GetResString(IDS_UPDATES));
//>>> shadow2004::IP2Country [EastShare]
		GetDlgItem(IDC_UPDATES_I2CGROUP)->SetWindowText(GetResString(IDS_UPDATES_I2CLABEL));
		GetDlgItem(IDC_UPDATES_I2CSTARTUP)->SetWindowText(GetResString(IDS_UPDATES_I2CAUTO));
		GetDlgItem(IDC_UPDATES_URLFORI2CLABEL)->SetWindowText(GetResString(IDS_UPDATES_I2CURLLABEL));
		GetDlgItem(IDC_UPDATES_URLFORI2CVERFILELABEL)->SetWindowText(GetResString(IDS_UPDATES_I2CURLVERLABEL));
		GetDlgItem(IDC_UPDATES_I2CRESET)->SetWindowText(GetResString(IDS_PW_RESET));
		GetDlgItem(IDC_UPDATES_I2CUPDATE)->SetWindowText(GetResString(IDS_SV_UPDATE));
//<<< shadow2004::IP2Country [EastShare]
//>>> shadow2004::ModIconDLL Update
		GetDlgItem(IDC_UPDATES_MIMGROUP)->SetWindowText(GetResString(IDS_UPDATES_MIMLABEL));
		GetDlgItem(IDC_UPDATES_MIMSTARTUP)->SetWindowText(GetResString(IDS_UPDATES_MIMAUTO));
		GetDlgItem(IDC_UPDATES_URLFORMIMLABEL)->SetWindowText(GetResString(IDS_UPDATES_MIMURLLABEL));
		GetDlgItem(IDC_UPDATES_MIMRESET)->SetWindowText(GetResString(IDS_PW_RESET));
		GetDlgItem(IDC_UPDATES_MIMUPDATE)->SetWindowText(GetResString(IDS_SV_UPDATE));
//<<< shadow2004::ModIconDLL Update

//>>> shadow2004::IPFilter-Update [Morph]
		GetDlgItem(IDC_IPFILTER_IPFGROUP)->SetWindowText(GetResString(IDS_IPFILTER_IPFGROUP));
		GetDlgItem(IDC_IPFILTER_IPFSTARTUP)->SetWindowText(GetResString(IDS_IPFILTER_IPFSTARTUP));
		GetDlgItem(IDC_IPFILTER_URLFORIPFLABEL)->SetWindowText(GetResString(IDS_IPFILTER_URLFORIPFLABEL));
		GetDlgItem(IDC_IPFILTER_IPFRESET)->SetWindowText(GetResString(IDS_PW_RESET));
		GetDlgItem(IDC_IPFILTER_IPFUPDATE)->SetWindowText(GetResString(IDS_SV_UPDATE));
//<<< shadow2004::IPFilter-Update [Morph]
//>>> shadow2004::ed2k updates
		GetDlgItem(IDC_IPFILTER_AUTODL)->SetWindowText(GetResString(IDS_IPFILTER_AUTODL));
		GetDlgItem(IDC_IPFILTER_ED2KPRIO)->SetWindowText(GetResString(IDS_IPFILTER_ED2KPRIO));
		GetDlgItem(IDC_IPFILTER_ED2KVLOW)->SetWindowText(GetResString(IDS_PRIOVERYLOW));
		GetDlgItem(IDC_IPFILTER_ED2KLOW)->SetWindowText(GetResString(IDS_PRIOLOW));
		GetDlgItem(IDC_IPFILTER_ED2KNORM)->SetWindowText(GetResString(IDS_PRIONORMAL));
		GetDlgItem(IDC_IPFILTER_ED2KHIGH)->SetWindowText(GetResString(IDS_PRIOHIGH));
		GetDlgItem(IDC_IPFILTER_ED2KREL)->SetWindowText(GetResString(IDS_PRIORELEASE));
		GetDlgItem(IDC_IPFILTER_ED2KAUTO)->SetWindowText(GetResString(IDS_PRIOAUTO));
//<<< shadow2004::ed2k updates
	}
}

//>>> shadow2004::IP2Country [EastShare]
void CPPgUpdates::OnBnClickedI2CUpdate()
{
	OnApply();
	theApp.ip2country->UpdateIP2CountryURL();
	CString strBuffer;
	strBuffer.Format(_T("v%u"), thePrefs.GetIP2CountryVersion());
	GetDlgItem(IDC_UPDATES_I2CVERSION)->SetWindowText(strBuffer);
}

void CPPgUpdates::OnBnClickedResetI2CURL()
{
	CString strBuffer = IP2COUNTRY_DEFAULT_URL;
	GetDlgItem(IDC_UPDATES_URLFORI2C)->SetWindowText(strBuffer);
	strBuffer = IP2COUNTRY_DEFAULT_VERURL;
	GetDlgItem(IDC_UPDATES_URLFORI2CVERFILE)->SetWindowText(strBuffer);
	thePrefs.SetIP2CountryVersion(0);
	strBuffer.Format(_T("v%u"), thePrefs.GetIP2CountryVersion());
	GetDlgItem(IDC_UPDATES_I2CVERSION)->SetWindowText(strBuffer);
}
//<<< shadow2004::IP2Country [EastShare]
//>>> shadow2004::ModIconDLL Update
void CPPgUpdates::OnBnClickedMIMUpdate()
{
	OnApply();
	theApp.theModIconMap->Update();
	GetDlgItem(IDC_UPDATES_MIMVERSION)->SetWindowText(theApp.theModIconMap->GetVersionString());
}

void CPPgUpdates::OnBnClickedResetMIMURL()
{
	GetDlgItem(IDC_UPDATES_URLFORMIM)->SetWindowText(MODICONDLL_DEFAULT_URL);
}
//<<< shadow2004::ModIconDLL Update

//>>> shadow2004::IPFilter-Update [Morph]
void CPPgUpdates::OnResetIPFilterURL()
{
	CString strBuffer = _T("");
	GetDlgItem(IDC_IPFILTER_URLFORIPF)->SetWindowText(MOD_ED2K_IPF_URL);	//>>> shadow2004::ed2k updates
	thePrefs.SetIpfilterVersion(0);
	thePrefs.SetDLingIpFilterVersion(0);
	thePrefs.SetDLingIpFilterLink(L"");
	strBuffer.Format(L"v%u", thePrefs.GetIPfilterVersion());
	if(thePrefs.GetDLingIpFilterVersion())
		strBuffer.AppendFormat(L" - %s v%u", GetResString(IDS_CD_CDOWN), thePrefs.GetDLingIpFilterVersion());
	GetDlgItem(IDC_IPFILTER_IPFVERSION)->SetWindowText(strBuffer);
}

void CPPgUpdates::OnLoadIPFilter()
{
	OnApply();
	theApp.ipfilter->UpdateIPFilterURL();
	CString strBuffer;
	strBuffer.Format(L"v%u", thePrefs.GetIPfilterVersion());
	if(thePrefs.GetDLingIpFilterVersion())
		strBuffer.AppendFormat(L" - %s v%u", GetResString(IDS_CD_CDOWN), thePrefs.GetDLingIpFilterVersion());
	GetDlgItem(IDC_IPFILTER_IPFVERSION)->SetWindowText(strBuffer);
}
//>>> shadow2004::IPFilter-Autocomplete
void CPPgUpdates::OnDestroy()
{
	DeleteDDB();
	CPropertyPage::OnDestroy();
}

void CPPgUpdates::DeleteDDB()
{
	if (m_pemfIPFilterURL)
	{
		m_pemfIPFilterURL->SaveList(thePrefs.GetMuleDirectory(EMULE_CONFIGDIR) + IPFILTERUPDATEURL_STRINGS_EMF);
		m_pemfIPFilterURL->Unbind();
		m_pemfIPFilterURL->Release();
		m_pemfIPFilterURL = NULL;
	}
}

void CPPgUpdates::OnListClicked()
{
	CWnd* box=GetDlgItem(IDC_IPFILTER_URLFORIPF);
	box->SetFocus();
	box->SetWindowText(_T(""));
	box->SendMessage(WM_KEYDOWN,VK_DOWN,0x00510001);
}

BOOL CPPgUpdates::PreTranslateMessage(MSG* pMsg) 
{
	if (pMsg->message == WM_KEYDOWN)
	{
		if (pMsg->wParam == VK_ESCAPE)
			return FALSE;

		if( m_pemfIPFilterURL && m_pemfIPFilterURL->IsBound() && ((pMsg->wParam == VK_DELETE) && (pMsg->hwnd == GetDlgItem(IDC_IPFILTER_URLFORIPF)->m_hWnd) && (GetAsyncKeyState(VK_MENU)<0 || GetAsyncKeyState(VK_CONTROL)<0)) )
			m_pemfIPFilterURL->Clear();

		if (pMsg->wParam == VK_RETURN)
		{
			if (pMsg->hwnd == GetDlgItem(IDC_IPFILTER_URLFORIPF)->m_hWnd)
			{
				if (m_pemfIPFilterURL && m_pemfIPFilterURL->IsBound() )
				{
					CString strText;
					GetDlgItem(IDC_IPFILTER_URLFORIPF)->GetWindowText(strText);
					if (!strText.IsEmpty())
					{
						GetDlgItem(IDC_IPFILTER_URLFORIPF)->SetWindowText(_T("")); // this seems to be the only chance to let the dropdown list to disapear
						GetDlgItem(IDC_IPFILTER_URLFORIPF)->SetWindowText(strText);
						((CEdit*)GetDlgItem(IDC_IPFILTER_URLFORIPF))->SetSel(strText.GetLength(), strText.GetLength());
					}
				}
				return TRUE;
			}
		}
	}

	return CPropertyPage::PreTranslateMessage(pMsg);
}
//<<< shadow2004::IPFilter-Autocomplete

//>>> shadow2004::ed2k updates
void CPPgUpdates::OnSettingsChange()
{
	SetModified();
	const BOOL bEnable = IsDlgButtonChecked(IDC_IPFILTER_ED2KPRIO);
	GetDlgItem(IDC_IPFILTER_ED2KAUTO)->EnableWindow(bEnable);
	GetDlgItem(IDC_IPFILTER_ED2KVLOW)->EnableWindow(bEnable);
	GetDlgItem(IDC_IPFILTER_ED2KLOW)->EnableWindow(bEnable);
	GetDlgItem(IDC_IPFILTER_ED2KNORM)->EnableWindow(bEnable);
	GetDlgItem(IDC_IPFILTER_ED2KHIGH)->EnableWindow(bEnable);
	GetDlgItem(IDC_IPFILTER_ED2KREL)->EnableWindow(bEnable);
}
//<<< shadow2004::ed2k updates